#version 330

uniform sampler2D color0Tex;
uniform sampler2D color1Tex;
uniform sampler2D lightTex;
uniform sampler2D aoTex;
//uniform sampler2D glowTex;
uniform mat4 invPersp;
uniform float farClip;

in vec4 uv;

out vec4 oColor;

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

vec4 screenToProj(vec2 iCoord)
{
    return vec4(2.0f * vec2(iCoord.x, 1.0f - iCoord.y) - 1, 0.0, 1.0);
}

vec3 decodeNormal(vec2 enc)
{
    vec2 fenc = enc*4 - 2;
    float f = dot(fenc, fenc);
    float g = sqrt(1 - f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1 - f/2;
    return n;
}

void main()
{
	vec4 normalDepth = textureLod(color0Tex, uv.xy, 0);
	vec4 diffuse_sun = textureLod(color1Tex, uv.xy, 0);
	
#if _DEBUG_ALBEDO
	oColor = vec4(diffuse_sun.rgb, 1.0);
#endif
#if _DEBUG_NORMALS
	oColor = vec4(decodeNormal(normalDepth.xy), 1.0);
#endif
#if _DEBUG_DEPTH
	//vec3 val = vec3(pow(1+normalDepth.z, 100));
	float val = -normalDepth.z;
	oColor = vec4(vec3(val), 1.0);
	if(normalDepth.z > 0) oColor = vec4(1.0, 0.0, 0.0, 1.0);
#endif
#if _DEBUG_POSITION
	vec4 projSpace = screenToProj(uv.xy);
	vec3 posVs = depthToPosition(normalDepth.z, projSpace);
	oColor = vec4(posVs.xy, -posVs.z, 1.0);
#endif
#if _DEBUG_SPECULAR
	oColor = vec4(diffuse_sun.aaa, 1.0);
#endif
#if _DEBUG_AO
	vec4 ao = textureLod(aoTex, uv.xy, 0);
	oColor = vec4(vec3(1.0) - ao.aaa, 1.0);
#endif
#if _DEBUG_LIGHT
	vec4 light = textureLod(lightTex, uv.xy, 0);
	oColor = vec4(light.rgb, 1.0);
#endif
#if _DEBUG_BLACK
	oColor = vec4(0.0, 0.0, 0.0, 1.0);
#endif
#if _DEBUG_GLOW
	vec4 glow = textureLod(glowTex, uv.xy, 0);
	oColor = vec4(glow.rgb, 1.0);
#endif
}
